/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.DatabaseInfo;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.ResourceBundle;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;

public class DatabaseConfig
extends Panel
implements JCActionListener {
    private JCButton collectionButton;
    private JCButton pbHelp;
    private Applet appl;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String DRIVER_NAME = adminRB.getString("s_DBDriver");
    private static final String DATABASE_URL = adminRB.getString("s_DBUrl");
    private static final String START_COLLECTION = adminRB.getString("s_DBStart");
    private static final String STOP_COLLECTION = adminRB.getString("s_DBStop");
    private static final String USER_ID = adminRB.getString("s_userID");
    private static final String PASSWORD = adminRB.getString("s_password");
    private TextField jdbcDriverName;
    private TextField databaseURL;
    private TextField userId;
    private TextField password;
    private DpAdminPanel adminPanel;

    public DatabaseConfig(DpAdminPanel dpAdminPanel, Applet applet) {
        super(new BorderLayout());
        this.appl = applet;
        try {
            this.adminPanel = dpAdminPanel;
            DatabaseInfo databaseInfo = this.adminPanel.getAdminInterface().getCollectionStatus();
            if (databaseInfo == null) {
                databaseInfo = new DatabaseInfo();
            }
            Panel panel = new Panel(new JCAlignerLayout(2, 10, 50));
            Label label = new Label(DRIVER_NAME);
            this.jdbcDriverName = new TextField(databaseInfo.getDriverName(), 30);
            panel.add(label);
            panel.add(this.jdbcDriverName);
            Label label2 = new Label(DATABASE_URL);
            this.databaseURL = new TextField(databaseInfo.getDatabaseURL(), 30);
            panel.add(label2);
            panel.add(this.databaseURL);
            Label label3 = new Label(USER_ID);
            this.userId = new TextField(databaseInfo.getUserId(), 15);
            panel.add(label3);
            panel.add(this.userId);
            Label label4 = new Label(PASSWORD);
            this.password = new TextField(databaseInfo.getPassword(), 15);
            this.password.setEchoChar('*');
            panel.add(label4);
            panel.add(this.password);
            if (!databaseInfo.isCollecting()) {
                this.collectionButton = new JCButton(START_COLLECTION);
            } else {
                this.collectionButton = new JCButton(STOP_COLLECTION);
                this.jdbcDriverName.setEnabled(false);
                this.databaseURL.setEnabled(false);
                this.userId.setEnabled(false);
                this.password.setEnabled(false);
            }
            this.collectionButton.addActionListener(this);
            this.pbHelp = new JCButton(adminRB.getString("s_Help"));
            this.pbHelp.addActionListener(this);
            Panel panel2 = new Panel(new FlowLayout(1));
            panel2.add(this.collectionButton);
            panel2.add(this.pbHelp);
            this.add("North", new Panel());
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(panel);
            this.add("Center", panel3);
            this.add("South", panel2);
            return;
        }
        catch (Exception exception) {
            System.out.println("an exception occurred:");
            exception.printStackTrace();
            return;
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        try {
            if (jCActionEvent.getSource() == this.collectionButton) {
                if (this.collectionButton.getLabel().equals(START_COLLECTION)) {
                    DatabaseInfo databaseInfo = new DatabaseInfo(this.jdbcDriverName.getText(), this.databaseURL.getText(), true);
                    databaseInfo.setUserId(this.userId.getText());
                    databaseInfo.setPassword(this.password.getText());
                    String string = this.adminPanel.getAdminInterface().setCollectionStatus(databaseInfo);
                    if (string != null) {
                        Frame frame = new Frame();
                        new MessageBox(frame, "", string, true);
                        return;
                    }
                    this.collectionButton.setLabel(STOP_COLLECTION);
                    this.jdbcDriverName.setEnabled(false);
                    this.databaseURL.setEnabled(false);
                    this.userId.setEnabled(false);
                    this.password.setEnabled(false);
                    return;
                }
                DatabaseInfo databaseInfo = new DatabaseInfo(this.jdbcDriverName.getText(), this.databaseURL.getText(), false);
                databaseInfo.setUserId(this.userId.getText());
                databaseInfo.setPassword(this.password.getText());
                String string = this.adminPanel.getAdminInterface().setCollectionStatus(databaseInfo);
                if (string != null) {
                    Frame frame = new Frame();
                    new MessageBox(frame, "", string, true);
                    return;
                }
                this.collectionButton.setLabel(START_COLLECTION);
                this.jdbcDriverName.setEnabled(true);
                this.databaseURL.setEnabled(true);
                this.userId.setEnabled(true);
                this.password.setEnabled(true);
                return;
            }
            if (jCActionEvent.getSource() == this.pbHelp) {
                NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
                if (this.appl instanceof BrowserApplet) {
                    BrowserApplet browserApplet = (BrowserApplet)this.appl;
                    browserApplet.showHelp(nhmHelpRef);
                    return;
                }
                this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("an exception occurred:");
            exception.printStackTrace();
        }
    }
}

